/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jrockit.jfr.client;

import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.FlightRecorderMBean;
import com.oracle.jrockit.jfr.management.FlightRecordingMBean;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.JFR;

@Deprecated
public final class FlightRecorderClient
implements FlightRecorderMBean {
    private final FlightRecorderMBean remote;
    private final MBeanServerConnection server;
    private static final ObjectName flightRecorderName;

    public FlightRecorderClient() throws InstanceNotFoundException, NullPointerException, IOException {
        this.remote = JFR.get().getMBean();
        this.server = null;
    }

    public FlightRecorderClient(MBeanServerConnection mBeanServerConnection) throws InstanceNotFoundException, NullPointerException, IOException {
        this(mBeanServerConnection, flightRecorderName);
    }

    public FlightRecorderClient(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws InstanceNotFoundException, NullPointerException, IOException {
        FlightRecorderMBean flightRecorderMBean = null;
        this.server = mBeanServerConnection;
        this.remote = flightRecorderMBean = MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, objectName, FlightRecorderMBean.class, true);
    }

    @Override
    public ObjectName createRecording(String string) {
        return this.remote.createRecording(string);
    }

    private FlightRecordingMBean getRecording(ObjectName objectName) throws NoSuchRecordingException {
        try {
            if (this.server != null) {
                return MBeanServerInvocationHandler.newProxyInstance(this.server, objectName, FlightRecordingMBean.class, true);
            }
            FlightRecorder flightRecorder = (FlightRecorder)this.remote;
            try {
                return flightRecorder.getRecordingMBean(objectName);
            }
            catch (OpenDataException openDataException) {
                throw (InternalError)new InternalError(openDataException.getMessage()).initCause(openDataException);
            }
        }
        catch (Exception exception) {
            throw new NoSuchRecordingException(objectName.toString(), exception);
        }
    }

    public FlightRecordingClient createRecordingObject(String string) throws NoSuchRecordingException {
        ObjectName objectName = this.createRecording(string);
        return new FlightRecordingClient(this, this.getRecording(objectName), objectName);
    }

    @Override
    public ObjectName startRecording(String string, CompositeData compositeData, List<CompositeData> list, List<CompositeData> list2) throws OpenDataException {
        return this.remote.startRecording(string, compositeData, list, list2);
    }

    public FlightRecordingClient startRecordingObject(String string, CompositeData compositeData, List<CompositeData> list, List<CompositeData> list2) throws OpenDataException {
        ObjectName objectName = this.startRecording(string, compositeData, list, list2);
        try {
            return new FlightRecordingClient(this, this.getRecording(objectName), objectName);
        }
        catch (NoSuchRecordingException noSuchRecordingException) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(ObjectName objectName, String string, boolean bl) throws IllegalStateException, IOException, NoSuchRecordingException {
        this.remote.copyTo(objectName, string, bl);
    }

    @Override
    public void disableDefaultRecording() {
        this.remote.disableDefaultRecording();
    }

    @Override
    public void enableDefaultRecording() {
        this.remote.enableDefaultRecording();
    }

    @Override
    public boolean isDefaultRecordingRunning() {
        return this.remote.isDefaultRecordingRunning();
    }

    @Override
    public long getDataSize(ObjectName objectName) throws NoSuchRecordingException {
        return this.remote.getDataSize(objectName);
    }

    @Override
    public void addEventDefaults(ObjectName objectName, List<CompositeData> list) throws OpenDataException, NoSuchRecordingException {
        this.remote.addEventDefaults(objectName, list);
    }

    @Override
    public List<CompositeData> getEventDefaults() throws OpenDataException {
        return this.remote.getEventDefaults();
    }

    @Override
    public List<CompositeData> getEventDefaults(ObjectName objectName) throws OpenDataException, NoSuchRecordingException {
        return this.remote.getEventDefaults(objectName);
    }

    @Override
    public void setEventDefaults(ObjectName objectName, List<CompositeData> list) throws OpenDataException, NoSuchRecordingException {
        this.remote.setEventDefaults(objectName, list);
    }

    @Override
    public List<CompositeData> getEventSettings() throws OpenDataException {
        return this.remote.getEventSettings();
    }

    @Override
    public List<CompositeData> getProducers() throws OpenDataException {
        return this.remote.getProducers();
    }

    @Override
    public List<CompositeData> getRecordings() throws OpenDataException {
        return this.remote.getRecordings();
    }

    public List<FlightRecordingClient> getRecordingObjects() throws OpenDataException, NoSuchRecordingException {
        List<CompositeData> list = this.getRecordings();
        ArrayList<FlightRecordingClient> arrayList = new ArrayList<FlightRecordingClient>(list.size());
        for (CompositeData compositeData : list) {
            ObjectName objectName = (ObjectName)compositeData.get("objectName");
            try {
                arrayList.add(new FlightRecordingClient(this, this.getRecording(objectName), objectName));
            }
            catch (NoSuchRecordingException noSuchRecordingException) {}
        }
        return arrayList;
    }

    @Override
    public void close(ObjectName objectName) throws NoSuchRecordingException {
        this.remote.close(objectName);
    }

    @Override
    public void closeStream(long l) throws IOException, IllegalArgumentException {
        this.remote.closeStream(l);
    }

    @Override
    public List<CompositeData> getEventSettings(ObjectName objectName) throws OpenDataException, NoSuchEventException, NoSuchRecordingException {
        return this.remote.getEventSettings(objectName);
    }

    @Override
    public long getPeriod(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.remote.getPeriod(objectName, n);
    }

    @Override
    public CompositeData getRecordingOptions(ObjectName objectName) throws OpenDataException, NoSuchRecordingException {
        return this.remote.getRecordingOptions(objectName);
    }

    @Override
    public long getThreshold(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.remote.getThreshold(objectName, n);
    }

    @Override
    public boolean isEventEnabled(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.remote.isEventEnabled(objectName, n);
    }

    @Override
    public boolean isStackTraceEnabled(ObjectName objectName, int n) throws NoSuchEventException, NoSuchRecordingException {
        return this.remote.isStackTraceEnabled(objectName, n);
    }

    @Override
    public long openStream(ObjectName objectName, Date date, Date date2) throws IOException, NoSuchRecordingException {
        return this.remote.openStream(objectName, date, date2);
    }

    @Override
    public long openStream(ObjectName objectName) throws NoSuchRecordingException, IOException {
        return this.remote.openStream(objectName);
    }

    @Override
    public byte[] readStream(long l) throws IOException, IllegalArgumentException {
        return this.remote.readStream(l);
    }

    @Override
    public void setEventEnabled(ObjectName objectName, int n, boolean bl) throws NoSuchEventException, NoSuchRecordingException {
        this.remote.setEventEnabled(objectName, n, bl);
    }

    @Override
    public void setPeriod(ObjectName objectName, int n, long l) throws NoSuchEventException, NoSuchRecordingException {
        this.remote.setPeriod(objectName, n, l);
    }

    @Override
    public void setRecordingOptions(ObjectName objectName, CompositeData compositeData) throws OpenDataException, NoSuchRecordingException {
        this.remote.setRecordingOptions(objectName, compositeData);
    }

    @Override
    public void setStackTraceEnabled(ObjectName objectName, int n, boolean bl) throws NoSuchEventException, NoSuchRecordingException {
        this.remote.setStackTraceEnabled(objectName, n, bl);
    }

    @Override
    public void setThreshold(ObjectName objectName, int n, long l) throws NoSuchEventException, NoSuchRecordingException {
        this.remote.setThreshold(objectName, n, l);
    }

    @Override
    public void start(ObjectName objectName) throws NoSuchRecordingException {
        this.remote.start(objectName);
    }

    @Override
    public void stop(ObjectName objectName) throws NoSuchRecordingException, IOException {
        this.remote.stop(objectName);
    }

    @Override
    public void updateEventSettings(ObjectName objectName, List<CompositeData> list) throws OpenDataException, NoSuchEventException, NoSuchRecordingException {
        this.remote.updateEventSettings(objectName, list);
    }

    @Override
    public long getThreshold(int n) throws NoSuchEventException {
        return this.remote.getThreshold(n);
    }

    @Override
    public boolean isEventEnabled(int n) throws NoSuchEventException {
        return this.remote.isEventEnabled(n);
    }

    @Override
    public boolean isStackTraceEnabled(int n) throws NoSuchEventException {
        return this.remote.isStackTraceEnabled(n);
    }

    @Override
    public List<CompositeData> getEventDescriptors() throws OpenDataException {
        return this.remote.getEventDescriptors();
    }

    @Override
    public ObjectName cloneRecording(ObjectName objectName, String string, boolean bl) throws NoSuchRecordingException, IOException {
        return this.remote.cloneRecording(objectName, string, bl);
    }

    public FlightRecordingClient cloneRecordingObject(ObjectName objectName, String string, boolean bl) throws NoSuchRecordingException, IOException {
        ObjectName objectName2 = this.cloneRecording(objectName, string, bl);
        return new FlightRecordingClient(this, this.getRecording(objectName2), objectName2);
    }

    @Override
    public void copyTo(ObjectName objectName, String string) throws IllegalStateException, IOException, NoSuchRecordingException {
        this.remote.copyTo(objectName, string);
    }

    @Override
    public List<CompositeData> getAvailablePresets() throws OpenDataException {
        return this.remote.getAvailablePresets();
    }

    @Override
    public long getMaximumRepositoryChunkSize() {
        return this.remote.getMaximumRepositoryChunkSize();
    }

    @Override
    public long getGlobalBufferSize() {
        return this.remote.getGlobalBufferSize();
    }

    @Override
    public long getThreadBufferSize() {
        return this.remote.getThreadBufferSize();
    }

    @Override
    public long getNumGlobalBuffers() {
        return this.remote.getNumGlobalBuffers();
    }

    @Override
    public String getRepositoryPath() {
        return this.remote.getRepositoryPath();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Flight Recorder MBean Client = {\n");
        try {
            for (FlightRecordingClient flightRecordingClient : this.getRecordingObjects()) {
                stringBuilder.append('\t').append(flightRecordingClient).append('\n');
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public CompositeData getRecordingOptionsDefaults() throws OpenDataException {
        return this.remote.getRecordingOptionsDefaults();
    }

    @Override
    public CompositeData getStatistics() throws OpenDataException {
        return this.remote.getStatistics();
    }

    @Override
    public Date getDataEndTime(ObjectName objectName) throws NoSuchRecordingException {
        return this.remote.getDataEndTime(objectName);
    }

    @Override
    public Date getDataStartTime(ObjectName objectName) throws NoSuchRecordingException {
        return this.remote.getDataStartTime(objectName);
    }

    static {
        try {
            flightRecorderName = new ObjectName("com.oracle.jrockit:type=FlightRecorder");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }
}

